/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos;

import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Establecimiento;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class DialogoEstablecimiento
extends DialogoBase
implements VistaModelo<Establecimiento> {
    private DataBindingContext m_bindingContext;
    private Text txtEstablecimiento;
    private Text txtTotalVentas;
    private Establecimiento modeloDatos;
    private Periodo periodo;
    private List<Establecimiento> establecimientosExistentes;
    private boolean editando;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private Text textTotalCompensado;
    private Label lblCompensaciones;

    public DialogoEstablecimiento(IWorkbenchPartSite site, List<Establecimiento> establecimientosExistentes, boolean editando) {
        super(site);
        this.setShellStyle(80);
        this.establecimientosExistentes = establecimientosExistentes;
        this.editando = editando;
    }

    protected Point getInitialSize() {
        return new Point(480, 253);
    }

    public void setModeloDatos(Establecimiento modeloDatos) {
        this.modeloDatos = modeloDatos;
        this.periodo = ((Iva)modeloDatos.getPropietario()).periodo;
    }

    public void procesarModeloDatos() {
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                if (!DialogoEstablecimiento.this.editando) {
                    for (Establecimiento e : DialogoEstablecimiento.this.establecimientosExistentes) {
                        if (!e.getEstablecimiento().equals(DialogoEstablecimiento.this.modeloDatos.getEstablecimiento())) continue;
                        resultado.fallarValidacion("El Establecimiento ya se encuentra registrado");
                        break;
                    }
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Ingrese la informaci\u00f3n del establecimiento");
        this.setTitle("Establecimiento");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblEstablecimiento = new Label(container, 0);
        lblEstablecimiento.setText("C\u00f3digo del establecimiento \n(conforme inscripci\u00f3n en el RUC)");
        this.txtEstablecimiento = new Text(container, 2048);
        this.txtEstablecimiento.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoEstablecimiento.this.txtEstablecimiento.selectAll();
            }
        });
        this.txtEstablecimiento.setTextLimit(3);
        GridData gd_txtEstablecimiento = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtEstablecimiento.widthHint = 100;
        this.txtEstablecimiento.setLayoutData((Object)gd_txtEstablecimiento);
        Label lblTotalVentas = new Label(container, 0);
        lblTotalVentas.setText("Total ventas por establecimiento");
        this.txtTotalVentas = new Text(container, 2048);
        this.txtTotalVentas.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoEstablecimiento.this.txtTotalVentas.selectAll();
            }
        });
        this.txtTotalVentas.setTextLimit(15);
        GridData gd_txtTotalVentas = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtTotalVentas.widthHint = 100;
        this.txtTotalVentas.setLayoutData((Object)gd_txtTotalVentas);
        this.lblCompensaciones = new Label(container, 0);
        this.lblCompensaciones.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblCompensaciones.setText("IVA Compensado en el establecimiento por ventas \nLey de Solidaridad-Zonas Afectadas");
        this.textTotalCompensado = new Text(container, 2048);
        this.textTotalCompensado.setTextLimit(15);
        GridData gd_textTotalCompensado = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_textTotalCompensado.widthHint = 100;
        this.textTotalCompensado.setLayoutData((Object)gd_textTotalCompensado);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtEstablecimientoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEstablecimiento);
        IObservableValue establecimientoModeloDatosObserveValue = BeanProperties.value((String)"establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtEstablecimientoObserveWidget, establecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtTotalVentasObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtTotalVentas);
        IObservableValue totalVentasModeloDatosObserveValue = BeanProperties.value((String)"totalVentas").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtTotalVentasObserveWidget, totalVentasModeloDatosObserveValue, null, null);
        ISWTObservableValue textTotalCompensadoObserveTextObserveWidget = SWTObservables.observeText((Control)this.textTotalCompensado, (int)24);
        IObservableValue modeloDatosTotalCompensadoObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"totalCompensado");
        bindingContext.bindValue((IObservableValue)textTotalCompensadoObserveTextObserveWidget, modeloDatosTotalCompensadoObserveValue, null, null);
        ISWTObservableValue lblCompensacionesObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblCompensaciones);
        IObservableValue periodoAnexoEnPeriodoDesdeJunio2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoDesdeJunio2016");
        bindingContext.bindValue((IObservableValue)lblCompensacionesObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeJunio2016ObserveValue, null, null);
        ISWTObservableValue textTotalCompensadoObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.textTotalCompensado);
        bindingContext.bindValue((IObservableValue)textTotalCompensadoObserveVisibleObserveWidget, periodoAnexoEnPeriodoDesdeJunio2016ObserveValue, null, null);
        return bindingContext;
    }
}

